//	Critical Mass be
//	13/7/1997
//	Hamish Carr
//
//	CMassView.h

#pragma once

class CMassView;							//	forward declaration

#include "CMBrain.h"
#include "CMSound.h"
#include "CMassApplication.h"
#include "CMSemaphore.h"

#define N_BITMAPS 13						//	1-5 red / blue, booms, white
#define CELL_EMPTY 6						//	offset into array of bitmaps

#define SLOW_SPEED 1200000					//	i.e. 1.2 second
#define MEDIUM_SPEED 600000					//	i.e. 0.6 second
#define FAST_SPEED 300000					//	i.e. 0.3 second

#define OptionFastDisplayItem		4002L
#define OptionMediumDisplayItem		4003L
#define OptionSlowDisplayItem		4004L

#define HUMAN_PLAYER 0						//	types for the players
#define RANDOM_PLAYER 1						//	random choice 
#define SMART_PLAYER 2						//	board evaluator
#define AI_PLAYER 3							//	shallow lookahead
#define BILL_KOCAY_PLAYER 4					//	deep lookahead

#define DIE_BAD_ENTRY SUICIDE_NOTE"I couldn't find the file with the pretty pictures (BEntry failed)"
#define DIE_BAD_FILE SUICIDE_NOTE"I couldn't find the file with the pretty pictures (BFile failed)"
#define DIE_BAD_RESOURCES SUICIDE_NOTE"I couldn't open the file with the pretty pictures (BResources failed)"
#define DIE_BAD_PICT SUICIDE_NOTE"I couldn't find one of the pictures (FindResource() failed)"
#define DIE_BAD_SOUND SUICIDE_NOTE"I couldn't find one of the sounds (FindResource() failed)"
#define DIE_BAD_PLAYER SUICIDE_NOTE"I lost track of whose turn it was.  Ooops!"
#define DIE_NO_DISPLAY_THREAD SUICIDE_NOTE"Came unstrung.  (system wouldn't give me a thread for display)"
#define DIE_RESUME_DISPLAY_FAILED SUICIDE_NOTE"Came unstrung.  Couldn't resume display thread after spawning."
#define DIE_NO_THINKING_THREAD SUICIDE_NOTE"Came unstrung.  (system wouldn't give me a thread for thinking)"
#define DIE_RESUME_THINKING_FAILED SUICIDE_NOTE"Came unstrung.  Couldn't resume thinking thread after spawning."

class CMassView : public BView 				//	our viewing panel
	{
	private:	
	CMBoard *theBoard;						//	the game board to use for moves
	CMBoard *theDisplayBoard;				//	the board currently being displayed
	long thePlayer;							//	whose turn it is currently
	CMBrain *theBrain;						//  the part that does the actual thinking
	BBitmap *theBitmaps[N_BITMAPS];			//	cache for the bitmaps
	long gameTurn;							//  which turn it is
	bool gameOver;							//	whether the game is over
	bool thePlayerIsHuman;					//	whether the current player is human
	
	public:									//	so that the window can access them
	long displaySpeed;						//	the speed of the display function
	long speedID;							//	used to keep track of checked menu item
	bool soundOn;							//	whether to play sounds
	long redPlayerType, bluePlayerType;		//	what type each player is
	
	private:
	long display_row, display_col;			//	used for displaying results of move
	long display_player;					//	used for displaying results of move
	
	bool mouse_moves_allowed;				//	whether human can click right now to move
											//	not a semaphore - permits throwing clicks away
	long displayOnNextPulse;				//	for forcing refreshes
	bool thinkingUpMove;					//	flag to prevent multiple thunks
	bool displayDone;						//	flag for whether display routine is done
	bool busyWithMouseDown;					//	flag for whether processing a mouse-down
	long winner;							//	who won
	bool canResetStatusBar;					//	to control reset of status bar

	//	semaphores for mutex in critical functions
	public:		// this one is needed in CMBoard
	CMSemaphore *displayBoardSemaphore;
	private:	// these ones aren't
	CMSemaphore *displaySemaphore;			// mutex for displaying execution of move
	CMSemaphore *mouseSemaphore;			// mutex for mouseDown moves
	CMSemaphore *turnSemaphore;				// mutex for turn updates
	CMSemaphore *thinkingSemaphore;			// mutex for thinker
	
	// thread IDs for display & execution to permit threaded thinking / display
	thread_id displayThread;				//	the thread that displays a move
	thread_id thinkingThread;				//	the thread that thinks up the next move
	
	private:
	BStatusBar *theStatusBar;				//	the status bar with which to report progress

	public:
	CMassView(BRect frame, char *name); 	//	constructor
	virtual	void Draw(BRect updateRect);	//	draws the board
	virtual void MouseDown(BPoint where);	//	reacts to mouse clicks
	void ShowBoard(							//	shows the current board
		int whichPlayer, 					//	whose move it just was
		bool explosion);					//	whether there are explosions

	void SwitchPlayers();					//	switch to the next player
	void NewGame(bool restart = true);		//	start a new game
	void SetPlayerType(int player, int Type);
											//	set the type of a given player
	void ToggleSound();						//	toggles sound on/off
	void SetDisplaySpeed(long newOption);	//	sets the speed of display
	
	private:								// 	internal use only
	void StartDisplayThread(long row, long col);	
											//	display a move's execution
	void DisplayMove();						//	the routine that actually does the display
	static int32 Display_Move(void *arg);	//	static function to start thread

	void StartThinkingThread();				//	display a move's execution
	void ThinkUpMove();						//	the routine that actually does the display
	static int32 Think_Up_Move(void *arg);	//	static function to start thread
	
	virtual void Pulse();					//	override inherited Pulse() function
	}; // end of class CMassView
